%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\NeedsTeXFormat{LaTeX2e}[2012/01/01]
%\ProvidesClass{JJMS}[2012/01/01]
\newcommand\@ptsize{}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagefalse
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
%DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{fleqn}{\input{fleqn.clo}\AtEndOfClass{\mathindent\z@}}
\DeclareOption{leqno}{\input{leqno.clo}}%ananfang
\let\if@mathematic\iftrue
\let\if@numbook\iffalse
\DeclareOption{numbook}{\let\if@envcntsect\iftrue
  \AtEndOfPackage{%
   \renewcommand\thefigure{\thesection.\@arabic\c@figure}%
   \renewcommand\thetable{\thesection.\@arabic\c@table}%
   \renewcommand\theequation{\thesection.\@arabic\c@equation}%
   \@addtoreset{figure}{section}%
   \@addtoreset{table}{section}%
   \@addtoreset{equation}{section}%
  }%
}
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}%
}
%
\let\if@runhead\iffalse
\DeclareOption{runningheads}{\let\if@runhead\iftrue}
\let\if@smartrunh\iffalse
\DeclareOption{smartrunhead}{\let\if@smartrunh\iftrue}
\DeclareOption{nosmartrunhead}{\let\if@smartrunh\iffalse}
\let\if@envcntreset\iffalse
\DeclareOption{envcountreset}{\let\if@envcntreset\iftrue}
\let\if@envcntsame\iffalse
\DeclareOption{envcountsame}{\let\if@envcntsame\iftrue}
\let\if@envcntsect\iffalse
\DeclareOption{envcountsect}{\let\if@envcntsect\iftrue}
\let\if@referee\iffalse
\DeclareOption{referee}{\let\if@referee\iftrue}
\def\makereferee{\def\baselinestretch{2}}
\let\if@instindent\iffalse
\DeclareOption{instindent}{\let\if@instindent\iftrue}
\let\if@smartand\iffalse
\DeclareOption{smartand}{\let\if@smartand\iftrue}
\let\if@spthms\iftrue
\DeclareOption{nospthms}{\let\if@spthms\iffalse}
\let\switch@texts\relax
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\let\journalopt\@empty
\DeclareOption*{\InputIfFileExists{\CurrentOption.clo}{%
\let\journalopt\CurrentOption}{%
\ClassWarning{YU}{Specified option or subpackage
"\CurrentOption" not found -}\OptionNotUsed}}
\ExecuteOptions{final,twocolumn,fleqn,a4paper,twoside,10pt,instindent}
\ProcessOptions\relax

\RequirePackage{color}
\RequirePackage{graphicx}
\RequirePackage{lastpage}
\RequirePackage[colorlinks=true,linkcolor=blue,citecolor=blue,citebordercolor={1 1 1},urlcolor=blue]{hyperref}
\RequirePackage{url}



\DeclareMathSymbol{\Gamma}{\mathalpha}{letters}{"00}
\DeclareMathSymbol{\Delta}{\mathalpha}{letters}{"01}
\DeclareMathSymbol{\Theta}{\mathalpha}{letters}{"02}
\DeclareMathSymbol{\Lambda}{\mathalpha}{letters}{"03}
\DeclareMathSymbol{\Xi}{\mathalpha}{letters}{"04}
\DeclareMathSymbol{\Pi}{\mathalpha}{letters}{"05}
\DeclareMathSymbol{\Sigma}{\mathalpha}{letters}{"06}
\DeclareMathSymbol{\Upsilon}{\mathalpha}{letters}{"07}
\DeclareMathSymbol{\Phi}{\mathalpha}{letters}{"08}
\DeclareMathSymbol{\Psi}{\mathalpha}{letters}{"09}
\DeclareMathSymbol{\Omega}{\mathalpha}{letters}{"0A}
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\setlength\parindent{15\p@}
\setlength\smallskipamount{3\p@ \@plus 1\p@ \@minus 1\p@}
\setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}
\setlength\headheight{12\p@}%12
\setlength\headsep   {16.74dd}
\setlength\topskip   {10\p@}
\setlength\footskip{30\p@}
\setlength\maxdepth{.5\topskip}
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\@settopoint\textwidth
\setlength\marginparsep {10\p@}
\setlength\marginparpush{5\p@}
\setlength\topmargin{-10pt}
\if@twocolumn
   \setlength\oddsidemargin {-30\p@}
   \setlength\evensidemargin{-30\p@}
\else
   \setlength\oddsidemargin {\z@}
   \setlength\evensidemargin{\z@}
\fi
\setlength\marginparwidth  {48\p@}
\setlength\footnotesep{8\p@}
\setlength{\skip\footins}{9\p@ \@plus 4\p@ \@minus 2\p@}
\setlength\floatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\textfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep   {20\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dblfloatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\@fptop{0\p@}
\setlength\@fpsep{12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\@fpbot{0\p@ \@plus 1fil}
\setlength\@dblfptop{0\p@}
\setlength\@dblfpsep{12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\@dblfpbot{0\p@ \@plus 1fil}
\setlength\partopsep{2\p@ \@plus 1\p@ \@minus 1\p@}
\def\@listi{\leftmargin\leftmargini
            \parsep \z@
            \topsep 6\p@ \@plus2\p@ \@minus4\p@
            \itemsep\parsep}
\let\@listI\@listi
\@listi
\def\@listii {\leftmargin\leftmarginii
              \labelwidth\leftmarginii
              \advance\labelwidth-\labelsep
              \topsep    \z@
              \parsep    \topsep
              \itemsep   \parsep}
\def\@listiii{\leftmargin\leftmarginiii
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep
              \topsep    \z@
              \parsep    \topsep
              \itemsep   \parsep}
\def\@listiv {\leftmargin\leftmarginiv
              \labelwidth\leftmarginiv
              \advance\labelwidth-\labelsep}
\def\@listv  {\leftmargin\leftmarginv
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep}
\def\@listvi {\leftmargin\leftmarginvi
              \labelwidth\leftmarginvi
              \advance\labelwidth-\labelsep}
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{4}
\renewcommand\topfraction{.9}
\setcounter{bottomnumber}{2}
\renewcommand\bottomfraction{.7}
\setcounter{totalnumber}{6}
\renewcommand\textfraction{.1}
\renewcommand\floatpagefraction{.85}
\setcounter{dbltopnumber}{3}
\renewcommand\dbltopfraction{.85}
\renewcommand\dblfloatpagefraction{.85}
\def\ps@headings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\small\rlap{\thepage}\hfil\leftmark\unskip}%
    \def\@oddhead{\small\rightmark\hfil\llap{\thepage}}%
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\def\setitemindent#1{\settowidth{\labelwidth}{#1}%
        \leftmargini\labelwidth
        \advance\leftmargini\labelsep
   \def\@listi{\leftmargin\leftmargini
        \labelwidth\leftmargini\advance\labelwidth by -\labelsep
        \parsep=\parskip
        \topsep=\medskipamount
        \itemsep=\parskip \advance\itemsep by -\parsep}}
\def\setitemitemindent#1{\settowidth{\labelwidth}{#1}%
        \leftmarginii\labelwidth
        \advance\leftmarginii\labelsep
\def\@listii{\leftmargin\leftmarginii
        \labelwidth\leftmarginii\advance\labelwidth by -\labelsep
        \parsep=\parskip
        \topsep=\z@
        \itemsep=\parskip \advance\itemsep by -\parsep}}
% labels of description
\def\descriptionlabel#1{\hspace\labelsep #1\hfil}

\def\description{\@ifnextchar[{\@describe}{\list{}{\labelwidth\z@
          \itemindent-\leftmargin \let\makelabel\descriptionlabel}}}
\let\enddescription\endlist
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\def\describelabel#1{#1\hfil}
\def\@describe[#1]{\relax\ifnum\@listdepth=0
\setitemindent{#1}\else\ifnum\@listdepth=1
\setitemitemindent{#1}\fi\fi
\list{--}{\let\makelabel\describelabel}}
%
\newdimen\logodepth
\logodepth=2.2cm
\newdimen\headerboxheight
\headerboxheight=180pt % 18 10.5dd-lines - 2\baselineskip
\newdimen\betweenumberspace          % dimension for space between
\betweenumberspace=3.33pt            % number and text of titles.
\newdimen\aftertext                  % dimension for space after
\aftertext=5pt                       % text of title.
\newdimen\headlineindent             % dimension for space between
\headlineindent=1.166cm              % number and text of headings.
\def\andname{and}
\if@mathematic
   \def\runinend{\enspace}
   \def\floatcounterend{\enspace}
   \def\sectcounterend{}
\else
   \def\runinend{.}
   \def\floatcounterend{.\ }
   \def\sectcounterend{.}
\fi
\def\lastandname{, and}
\def\mailname{Corresponding author e-mail:}
\def\email#1{{e-mail: #1}}
\def\keywordname{{\bfseries Abstract:}\enspace}
\def\abstracttext#1{\gdef\@abstracttext{#1}}
\def\@abstracttext{}
\def\setabstracttext{%
  \ifx\@abstracttext\@empty\else
    \par\addvspace\baselineskip\noindent\keywordname
    \ignorespaces\@abstracttext
  \fi
}
\def\receivedname{{\normalfont Received:}\ }
\def\received#1{\gdef\@received{#1}}
\def\@received{}
\def\setreceived{%
  \ifx\@received\@empty\else
    \par\noindent\receivedname
    \ignorespaces\@received
  \fi
}
\def\revisedname{{, \normalfont Revised:}\ }
\def\revised#1{\gdef\@revised{#1}}
\def\@revised{}
\def\setrevised{%
  \ifx\@revised\@empty\else
    \revisedname
    \ignorespaces\@revised
  \fi
}
\def\acceptedname{{, \normalfont Accepted:}\ }
\def\accepted#1{\gdef\@accepted{#1}}
\def\@accepted{}
\def\setaccepted{%
  \ifx\@accepted\@empty\else
    \acceptedname
    \ignorespaces\@accepted
  \fi
}
\def\publishedname{{\normalfont Published online:}\ }
\def\published#1{\gdef\@published{#1}}
\def\@published{}
\def\setpublished{%
  \ifx\@published\@empty\else
    \par\noindent\publishedname
    \ignorespaces\@published
  \fi
}
\def\keywordsname{{\bfseries Keywords:}\enspace}
\def\keywords#1{\gdef\@keywords{#1}}
\def\@keywords{}
\def\setkeywords{%
  \ifx\@keywords\@empty\else
    \par\addvspace\baselineskip\noindent\keywordsname
    \ignorespaces\@keywords
  \fi
}
\def\abstracttext@keywords{%
  \@tempswafalse
  \ifx\@abstracttext\@empty
  \ifx\@keywords\@empty\else\@tempswatrue\fi
  \else\@tempswatrue\fi
  \if@tempswa
    \par\addvspace{\baselineskip}%
    \noindent{\color{rulecolor}\rule{\textwidth}{2pt}}%
    \normalcolor\setabstracttext\setkeywords
    \par\addvspace{\ht\strutbox}%
    \noindent{\color{rulecolor}\rule{\textwidth}{2pt}}\par
  \fi
}
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\newcounter{inst}
\newcounter{auth}
\def\authdepth{2}
\newdimen\instindent
\newbox\authrun
\newtoks\authorrunning
\newbox\titrun
\newtoks\titlerunning
\def\authorfont{\itshape}%hhh

\def\combirunning#1{\gdef\@combi{#1}}
\def\@combi{}
\newbox\combirun
%
\def\ps@last{\def\@evenhead{\small\rlap{\thepage}\hfil
\lastevenhead}}
\newcounter{lastpage}
\def\islastpageeven{\@ifundefined{lastpagenumber}
{\setcounter{lastpage}{0}}{\setcounter{lastpage}{\lastpagenumber}}
\ifnum\value{lastpage}>0
   \ifodd\value{lastpage}%
   \else
      \if@smartrunh
         \thispagestyle{last}%
      \fi
   \fi
\fi}
\def\getlastpagenumber{\clearpage
\addtocounter{page}{-1}%
   \immediate\write\@auxout{\string\gdef\string\lastpagenumber{\thepage}}%
   \immediate\write\@auxout{\string\newlabel{LastPage}{{}{\thepage}}}%
   \addtocounter{page}{1}}

\def\journalname#1{\gdef\@journalname{#1}}

\def\dedication#1{\gdef\@dedic{#1}}
\def\@dedic{}

\let\@date\@empty

\def\institute#1{\gdef\@institute{#1}}

\def\institutename{\par
 \begingroup
 \parindent=0pt
 \parskip=0pt
 \setcounter{inst}{1}%
 \def\and{\par\stepcounter{inst}%
 \if@instindent\hangindent\instindent\fi
 \noindent
 %\hbox to\instindent{\hss\smash{$^{\theinst}$}\enspace}\ignorespaces}%
 \hbox%hhh
{$^{\theinst}$\,}\ignorespaces}%
 \setbox0=\vbox{\def\thanks##1{}\@institute}
 \ifnum\value{inst}>9\relax\setbox0=\hbox{$^{88}$\enspace}%
                 \else\setbox0=\hbox{$^{8}$\enspace}\fi
 \instindent=\wd0\relax
 \ifnum\value{inst}=1\relax
 \else
   \setcounter{inst}{1}%
   \if@instindent\hangindent\instindent\fi
   \noindent
   \hbox%hhh
{$^{\theinst}$\,}\ignorespaces
 \fi
 \small
 \ignorespaces
 \@institute\par
 \endgroup}

\def\offprints#1{\begingroup
\def\protect{\noexpand\protect\noexpand}\xdef\@thanks{\@thanks
\protect\footnotetext[0]{\unskip\hskip-15pt{\itshape Send offprint requests
to\/}: \ignorespaces#1}}\endgroup\ignorespaces}

\def\mail#1{\gdef\@mail{#1}}
\def\@mail{}

\def\@thanks{}

\def\@fnsymbol#1{\ifcase#1\or\star\or{\star\star}\or{\star\star\star}%
   \or \dagger\or \ddagger\or
   \mathchar "278\or \mathchar "27B\or \|\or **\or \dagger\dagger
   \or \ddagger\ddagger \else\@ctrerr\fi\relax}

\def\inst#1{\unskip\,$^{#1}$}
\def\fnmsep{\unskip$^,$}

\def\subtitle#1{\gdef\@subtitle{#1}}
\def\@subtitle{}

\def\headnote#1{\gdef\@headnote{\normalfont\small#1}}%%%hhh
\def\@headnote{}
\def\abstract#1{\gdef\@abstract{\small{\bf Abstract:} #1}}%%%hhh
\def\@abstract{}
\let\endabstract\relax

%\newcommand*{\titlefigure}[2][]{\gdef\@titlefigure{\vspace*{-3mm}\includegraphics[#1]{#2}}}
%\def\@titlefigure{}\titlefigure{x}


\def\titlefigurecaption#1{\gdef\@titlefigurecaption{\leftskip=8.2cm \small #1}}
\def\@titlefigurecaption{}

\def\ch@ckobl#1#2{\@ifundefined{@#1}
 {\typeout{Warning: Missing
\expandafter\string\csname#1\endcsname}%
  \csname #1\endcsname{#2}}
 {}}
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\def\ProcessRunnHead{%
    \def\\{\unskip\ \ignorespaces}\def\inst##1{\unskip{}}%
    \def\thanks##1{\unskip{}}\def\fnmsep{\unskip}%
    \instindent=\textwidth
    \advance\instindent by-\headlineindent
    \if!\the\titlerunning!\else
      \edef\@title{\the\titlerunning}%
    \fi
    \global\setbox\titrun=\hbox{\small\rmfamily\unboldmath\ignorespaces\@title
                                \unskip}%
    \ifdim\wd\titrun>\instindent
       \typeout{^^JWarning: Title too long for running head.}%
       \typeout{Please supply a shorter form with \string\titlerunning
                \space prior to \string\maketitle}%
       \global\setbox\titrun=\hbox{\small\rmfamily
       Title Suppressed Due to Excessive Length}%
    \fi
    \xdef\@title{\copy\titrun}%
%
    \if!\the\authorrunning!
    \else
      \setcounter{auth}{1}%
      \edef\@author{\the\authorrunning}%
    \fi
    \ifnum\value{auth}>\authdepth
       \def\stripauthor##1\and##2\endauthor{%
       \protected@xdef\@author{##1\unskip\unskip\if!##2!\else\ et al.\fi}}%
       \expandafter\stripauthor\@author\and\endauthor
    \else
       \gdef\and{\unskip, \ignorespaces}%
       {\def\and{\noexpand\protect\noexpand\and}%
       \protected@xdef\@author{\@author}}
    \fi
    \global\setbox\authrun=\hbox{\small\rmfamily\unboldmath\ignorespaces
                                 \@author\unskip}%
    \ifdim\wd\authrun>\instindent
    \typeout{^^JWarning: Author name(s) too long for running head.
             ^^JPlease supply a shorter form with \string\authorrunning
             \space prior to \string\maketitle}%
    \global\setbox\authrun=\hbox{\small\rmfamily Please give a shorter version
          with: {\tt\string\authorrunning\space and
             \string\titlerunning\space prior to \string\maketitle}}%
    \fi
    \xdef\@author{\copy\authrun}%
    \markboth{\@author}{\@title}%
}
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\def\maketitle{\par
\ch@ckobl{journalname}{Noname}
%\ch@ckobl{date}{The date of receipt and acceptance will be inserted by
%the editor}
\ch@ckobl{title}{A title should be given}
\ch@ckobl{author}{Name(s) and initial(s) of author(s) should be given}
\ch@ckobl{institute}{Address(es) of author(s) should be given}
%\ch@ckobl{titlefigure}{Titlefigure should be given}
%\ch@ckobl{abstract}{Abstract should be given}
\begingroup
%
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{$^{\@thefnmark}$}%
%
 \def\lastand{\ifnum\value{inst}=2\relax
                 \unskip{} \andname\
              \else
                 \unskip, \andname\
              \fi}%
 \def\and{\stepcounter{auth}\relax
          \if@smartand
             \ifnum\value{auth}=\value{inst}%
                \lastand
             \else
                \unskip,
             \fi
          \else
             \unskip,
          \fi}%
 \ifnum \col@number=\@ne
   \@maketitle
 \else
   \twocolumn[\@maketitle]%
 \fi
% \thispagestyle{empty}
 \global\@topnum\z@
 \@thanks
% \if!\@mail!\else
%    \footnotetext[0]{\kern-\bibindent\mailname\
%    \ignorespaces\@mail}%
% \fi
%
 \if@runhead
    \ProcessRunnHead
    \if@smartrunh
       \instindent=\textwidth
       \advance\instindent by-\headlineindent
       \if!\@combi!%
          \global\setbox\combirun=\hbox{\small\rmfamily\unboldmath\ignorespaces
                                        \@author\unskip: \@title\unskip}%
          \def\@tempa{Automatically generated running head}%
       \else
          \global\setbox\combirun=\hbox{\small\rmfamily\unboldmath\ignorespaces
                                        \@combi\unskip}%
          \def\@tempa{With \string\combirunning\space supplied running head}%
       \fi
       \ifdim\wd\combirun>\instindent
          \typeout{^^JWarning: \@tempa}%
          \typeout{for a possible last even numbered page is too long.}%
          \typeout{Please supply a shorter form with \string\combirunning
                   \space prior to \string\maketitle.}%
          \global\setbox\combirun=\hbox{\small\rmfamily
          Title Suppressed Due to Excessive Length --
          supply \ttfamily\char92combirunning}%
       \fi
       \xdef\lastevenhead{\copy\combirun}%
    \fi
 \fi
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
 \endgroup
 \setcounter{footnote}{0}
 \global\let\thanks\relax
 \global\let\maketitle\relax
 \global\let\@maketitle\relax
 \global\let\@thanks\@empty
 \global\let\@author\@empty
 \global\let\@date\@empty
 \global\let\@title\@empty
 \global\let\@subtitle\@empty
 \global\let\title\relax
 \global\let\author\relax
 \global\let\date\relax
 \global\let\and\relax}


\def\makeheadbox{%
}

\def\titlefont{\normalfont}
\definecolor{abstractcolor}{named}{YellowGreen}
\definecolor{rulecolor}{named}{LimeGreen}

\def\@setabstractpart{%
  \parbox[t]{\columnwidth}{\@abstract}%
}

\def\abstractcaptionminskip{\baselineskip}
\newcommand*{\@setxabstractpart}[1][]{%
  \def\@tempa{\parbox[t]}%
  \ifx\relax#1\relax\else\def\@tempa{\parbox[t][#1][t]}\fi
  \@tempa{\columnwidth}{%
    \@abstract\par
    \vspace{\abstractcaptionminskip }%HHH
    \@titlefigurecaption
  }%
}

\def\@setfigurepart{%Legende~neben~Abb.
  \parbox[t]{\columnwidth}{%
    \vspace*{0pt}\vspace{-\baselineskip}%hhh
    \setlength{\@tempdima}{\dp\strutbox}\vspace{.4\@tempdima}%
    %{\centering\@titlefigure\\}%
  }%
}%

\newcommand*\@setxfigurepart[1][]{%Legende~unter~Abb.
  \def\@tempa{\parbox[t]}%
  \ifx\relax#1\relax\else\def\@tempa{\parbox[t][#1][t]}\fi
  \@tempa{\columnwidth}{%
    \vspace*{0pt}\vspace{-\ht\strutbox}\vspace{-1pt}%
    %{\centering\@titlefigure\\}%
    %\vfill% einkommentieren, wenn die caption nach unten soll
    \vspace{0.2cm}%
    \@titlefigurecaption
  }%
}

\newcommand{\@settototalheight}[2]{%
  \settoheight{#1}{#2}%
  \settodepth{\@tempdimc}{#2}%
  \addtolength{#1}{\@tempdimc}%
}

\def\copyrightmark{%
  {%
    \fontsize{6}{7.2pt}\selectfont
    \mbox{\begin{tabular}{@{}l@{}}
      \textcopyright\ \theyear\ YU \\
Deanship of Research and Graduate
Studies, Yarmouk University, Irbid, Jordan.
\end{tabular}
    }%
  }%
}

\def\@maketitle{\newpage
 \normalfont
 \vbox to0pt{\vskip-40pt
 \nointerlineskip
 \makeheadbox\vss}\nointerlineskip
 %\vspace*{-\headsep}
 %\vspace*{-\topskip}%
 \vspace{-1.25cm}
 \noindent \colorbox{abstractcolor}{%
   \@settototalheight{\@tempdima}{\@setxabstractpart}%
   \@settototalheight{\@tempdimb}{\@setfigurepart}%
   \setlength{\@tempdimc}{\textwidth}%
  \addtolength{\@tempdimc}{-2\fboxsep}%
   \ifdim\@tempdima>\@tempdimb
     \parbox[t]{\@tempdimc}{%
       \@settototalheight{\@tempdima}{\@setabstractpart}%
       \@settototalheight{\@tempdimb}{\@setxfigurepart}%
       \ifdim\@tempdima>\@tempdimb
         \settoheight{\@tempdimb}{\@setabstractpart}%
       \fi
       \@setabstractpart
       \hfill
       \@setxfigurepart[\@tempdimb]%
     }%
   \else
     \parbox[t]{\@tempdimc}{%
       \@settototalheight{\@tempdimb}{\strut\@setfigurepart}%
       \strut\@setxabstractpart[\@tempdimb]%
       \hfill
       \@setfigurepart
     }%
   \fi
 }%
 \vspace{3.5mm}


%\def\doi{doi}
\urlstyle{same}
\hbox{~}\hfill {\scriptsize \url{\doi} \\ }
 \vspace{-3\baselineskip}%
 \setbox\authrun=\vbox\bgroup
 {\Large \bfseries\boldmath
  \hrule\@height\logodepth\@width\z@
  \pretolerance=10000
  \rightskip=0pt plus 4cm
 \if!\@headnote!\else %%%%hhh
   \noindent
   {\normalfont\em\ignorespaces\@headnote\par}\vskip 3.5mm
 \fi
  \noindent\ignorespaces
  {\titlefont\@title \par}}\vskip 11.24pt\relax
 \if!\@subtitle!\else
   {\large\bfseries\boldmath
   \pretolerance=10000
   \rightskip=0pt plus 3cm
   \noindent\ignorespaces\@subtitle \par}\vskip 11.24pt
 \fi
 \normalfont\authorfont
 \lineskip .5em
 \setbox0=\vbox{\setcounter{auth}{1}\def\and{\stepcounter{auth} }%
                \hfuzz=2\textwidth\def\thanks##1{}\@author}%
 \value{inst}=\value{auth}%
 \setcounter{auth}{1}%
 \rightskip=0pt plus 2cm
 \noindent\ignorespaces\@author\vskip7.23pt
 \rightskip=0pt\relax
 \normalfont\small\rmfamily
 \institutename
 \if!\@date!\else\vskip 12.85pt \noindent\@date\fi
 \if!\@dedic!\else
    \par
    \small\itshape
    \addvspace\baselineskip
    \noindent\@dedic
 \fi
 \par\vspace{\baselineskip}
 \setreceived
 \setrevised
 \setaccepted
 \setpublished
 \abstracttext@keywords
 \egroup % end of header box
 \@tempdima=\headerboxheight
 \advance\@tempdima by-\ht\authrun
 \ifdim\@tempdima>0pt
    \vrule width0pt height\@tempdima
 \fi
 \unvbox\authrun
 \global\@minipagetrue
 \global\everypar{\global\@minipagefalse\global\everypar{}}
 \vskip2.5\baselineskip
}
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\if@mathematic
   \def\vec#1{\ensuremath{\mathchoice
                     {\mbox{\boldmath$\displaystyle\mathbf{#1}$}}
                     {\mbox{\boldmath$\textstyle\mathbf{#1}$}}
                     {\mbox{\boldmath$\scriptstyle\mathbf{#1}$}}
                     {\mbox{\boldmath$\scriptscriptstyle\mathbf{#1}$}}}}
\else
   \def\vec#1{\ensuremath{\mathchoice
                     {\mbox{\boldmath$\displaystyle#1$}}
                     {\mbox{\boldmath$\textstyle#1$}}
                     {\mbox{\boldmath$\scriptstyle#1$}}
                     {\mbox{\boldmath$\scriptscriptstyle#1$}}}}
\fi
%
\def\tens#1{\ensuremath{\mathsf{#1}}}
%
\setcounter{secnumdepth}{3}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand\thesection      {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection.\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
%
\def\@hangfrom#1{\setbox\@tempboxa\hbox{#1}%
      \hangindent \z@\noindent\box\@tempboxa}

\def\@seccntformat#1{\csname the#1\endcsname\sectcounterend
\hskip\betweenumberspace}

\def\@sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
        \@hangfrom{\hskip #3\relax\@svsec}%
          \raggedright
          \hyphenpenalty \@M%
          \interlinepenalty \@M #8\@@par}%
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname\sectcounterend}%
      \fi
      #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8\hskip\aftertext}%
      \csname #1mark\endcsname{#7}%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #7}}%
  \fi
  \@xsect{#5}}
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\
% measures and setting of sections
%
\def\section{\@startsection{section}{1}{\z@}%
    {-21dd plus-4pt minus-4pt}{10.5dd plus 4pt
     minus4pt}{\normalsize\bfseries\boldmath}}
\def\subsection{\@startsection{subsection}{2}{\z@}%
    {-21dd plus-4pt minus-4pt}{10.5dd plus 4pt
     minus4pt}{\normalsize\itshape}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}%
    {-13dd plus-4pt minus-4pt}{-5.5pt}{\normalsize\itshape}}
\def\paragraph{\@startsection{paragraph}{4}{\z@}%
    {-13pt plus-4pt minus-4pt}{-5.5pt}{\normalsize\itshape}}

\setlength\leftmargini  {\parindent}
\leftmargin  \leftmargini
\setlength\leftmarginii {\parindent}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\setlength\leftmarginv  {.5em}
\setlength\leftmarginvi {.5em}
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\normalfont\bfseries --}
\newcommand\labelitemii{\normalfont\bfseries --}
\newcommand\labelitemiii{$\m@th\bullet$}
\newcommand\labelitemiv{$\m@th\cdot$}

\if@spthms
%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\

\def\@thmcountersep{}
\def\@thmcounterend{}

\def\spnewtheorem{\@ifstar{\@sthm}{\@Sthm}}

% definition of \spnewtheorem with number

\def\@spnthm#1#2{%
  \@ifnextchar[{\@spxnthm{#1}{#2}}{\@spynthm{#1}{#2}}}
\def\@Sthm#1{\@ifnextchar[{\@spothm{#1}}{\@spnthm{#1}}}

\def\@spxnthm#1#2[#3]#4#5{\expandafter\@ifdefinable\csname #1\endcsname
   {\@definecounter{#1}\@addtoreset{#1}{#3}%
   \expandafter\xdef\csname the#1\endcsname{\expandafter\noexpand
     \csname the#3\endcsname \noexpand\@thmcountersep \@thmcounter{#1}}%
   \expandafter\xdef\csname #1name\endcsname{#2}%
   \global\@namedef{#1}{\@spthm{#1}{\csname #1name\endcsname}{#4}{#5}}%
                              \global\@namedef{end#1}{\@endtheorem}}}

\def\@spynthm#1#2#3#4{\expandafter\@ifdefinable\csname #1\endcsname
   {\@definecounter{#1}%
   \expandafter\xdef\csname the#1\endcsname{\@thmcounter{#1}}%
   \expandafter\xdef\csname #1name\endcsname{#2}%
   \global\@namedef{#1}{\@spthm{#1}{\csname #1name\endcsname}{#3}{#4}}%
                               \global\@namedef{end#1}{\@endtheorem}}}

\def\@spothm#1[#2]#3#4#5{%
  \@ifundefined{c@#2}{\@latexerr{No theorem environment `#2' defined}\@eha}%
  {\expandafter\@ifdefinable\csname #1\endcsname
  {\global\@namedef{the#1}{\@nameuse{the#2}}%
  \expandafter\xdef\csname #1name\endcsname{#3}%
  \global\@namedef{#1}{\@spthm{#2}{\csname #1name\endcsname}{#4}{#5}}%
  \global\@namedef{end#1}{\@endtheorem}}}}

\def\@spthm#1#2#3#4{\topsep 7\p@ \@plus2\p@ \@minus4\p@
\refstepcounter{#1}%
\@ifnextchar[{\@spythm{#1}{#2}{#3}{#4}}{\@spxthm{#1}{#2}{#3}{#4}}}

\def\@spxthm#1#2#3#4{\@spbegintheorem{#2}{\csname the#1\endcsname}{#3}{#4}%
                    \ignorespaces}

\def\@spythm#1#2#3#4[#5]{\@spopargbegintheorem{#2}{\csname
       the#1\endcsname}{#5}{#3}{#4}\ignorespaces}

\def\@spbegintheorem#1#2#3#4{\trivlist
                 \item[\hskip\labelsep{#3#1\ #2\@thmcounterend}]#4}

\def\@spopargbegintheorem#1#2#3#4#5{\trivlist
      \item[\hskip\labelsep{#4#1\ #2}]{#4(#3)\@thmcounterend\ }#5}

% definition of \spnewtheorem* without number

\def\@sthm#1#2{\@Ynthm{#1}{#2}}

\def\@Ynthm#1#2#3#4{\expandafter\@ifdefinable\csname #1\endcsname
   {\global\@namedef{#1}{\@Thm{\csname #1name\endcsname}{#3}{#4}}%
    \expandafter\xdef\csname #1name\endcsname{#2}%
    \global\@namedef{end#1}{\@endtheorem}}}

\def\@Thm#1#2#3{\topsep 7\p@ \@plus2\p@ \@minus4\p@
\@ifnextchar[{\@Ythm{#1}{#2}{#3}}{\@Xthm{#1}{#2}{#3}}}

\def\@Xthm#1#2#3{\@Begintheorem{#1}{#2}{#3}\ignorespaces}

\def\@Ythm#1#2#3[#4]{\@Opargbegintheorem{#1}
       {#4}{#2}{#3}\ignorespaces}

\def\@Begintheorem#1#2#3{#3\trivlist
                           \item[\hskip\labelsep{#2#1\@thmcounterend}]}

\def\@Opargbegintheorem#1#2#3#4{#4\trivlist
      \item[\hskip\labelsep{#3#1}]{#3(#2)\@thmcounterend\ }}

\if@envcntsect
   \def\@thmcountersep{.}
   \spnewtheorem{theorem}{Theorem}[section]{\bfseries}{\itshape}
\else
   \spnewtheorem{theorem}{Theorem}{\bfseries}{\itshape}
   \if@envcntreset
      \@addtoreset{theorem}{section}
   \else
      \@addtoreset{theorem}{chapter}
   \fi
\fi

%definition of divers theorem environments
\spnewtheorem*{claim}{Claim}{\itshape}{\rmfamily}
\spnewtheorem*{proof}{Proof}{\itshape}{\rmfamily}
\if@envcntsame % alle Umgebungen wie Theorem.
   \def\spn@wtheorem#1#2#3#4{\@spothm{#1}[theorem]{#2}{#3}{#4}}
\else % alle Umgebungen mit eigenem Zaehler
   \if@envcntsect % mit section numeriert
      \def\spn@wtheorem#1#2#3#4{\@spxnthm{#1}{#2}[section]{#3}{#4}}
   \else % nicht mit section numeriert
      \if@envcntreset
         \def\spn@wtheorem#1#2#3#4{\@spynthm{#1}{#2}{#3}{#4}
                                   \@addtoreset{#1}{section}}
      \else
         \let\spn@wtheorem=\@spynthm
      \fi
   \fi
\fi
\spn@wtheorem{case}{Case}{\itshape}{\rmfamily}
\spn@wtheorem{conjecture}{Conjecture}{\itshape}{\rmfamily}
\spn@wtheorem{corollary}{Corollary}{\bfseries}{\itshape}
\spn@wtheorem{definition}{Definition}{\bfseries}{\itshape}
\spn@wtheorem{example}{Example}{\itshape}{\rmfamily}
\spn@wtheorem{exercise}{Exercise}{\bfseries}{\rmfamily}
\spn@wtheorem{lemma}{Lemma}{\bfseries}{\itshape}
\spn@wtheorem{note}{Note}{\itshape}{\rmfamily}
\spn@wtheorem{problem}{Problem}{\bfseries}{\rmfamily}
\spn@wtheorem{property}{Property}{\itshape}{\rmfamily}
\spn@wtheorem{proposition}{Proposition}{\bfseries}{\itshape}
\spn@wtheorem{question}{Question}{\itshape}{\rmfamily}
\spn@wtheorem{solution}{Solution}{\bfseries}{\rmfamily}
\spn@wtheorem{remark}{Remark}{\itshape}{\rmfamily}

\def\theopargself{\def\@spopargbegintheorem##1##2##3##4##5{\trivlist
      \item[\hskip\labelsep{##4##1\ ##2}]{##4##3\@thmcounterend\ }##5}
                  \def\@Opargbegintheorem##1##2##3##4{##4\trivlist
      \item[\hskip\labelsep{##3##1}]{##3##2\@thmcounterend\ }}
      }
\fi

\def\@takefromreset#1#2{%
    \def\@tempa{#1}%
    \let\@tempd\@elt
    \def\@elt##1{%
        \def\@tempb{##1}%
        \ifx\@tempa\@tempb\else
            \@addtoreset{##1}{#2}%
        \fi}%
    \expandafter\expandafter\let\expandafter\@tempc\csname cl@#2\endcsname
    \expandafter\def\csname cl@#2\endcsname{}%
    \@tempc
    \let\@elt\@tempd}

\def\squareforqed{\hbox{\rlap{$\sqcap$}$\sqcup$}}
\def\qed{\ifmmode\else\unskip\quad\fi\squareforqed}
\def\smartqed{\def\qed{\ifmmode\squareforqed\else{\unskip\nobreak\hfil
\penalty50\hskip1em\null\nobreak\hfil\squareforqed
\parfillskip=0pt\finalhyphendemerits=0\endgraf}\fi}}

%\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\
%\\\\\\\\\\\\\\\\\\\\\\\\\\\\


%
\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}
\newcommand\appendix{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \renewcommand\thesection{\@Alph\c@section}}
\setlength\arraycolsep{1.5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
%\setlength\fboxsep{3\p@}
\setlength\fboxsep{6\p@}
\setlength\fboxrule{.4\p@}
\renewcommand\theequation{\@arabic\c@equation}
\newcounter{figure}
\renewcommand\thefigure{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newenvironment{figure}[1][]%hhh
               {\@float{figure}[{#1}]\vspace*{\baselineskip}}
               {\end@float}
\newenvironment{figure*}[1][]
               {\@dblfloat{figure}[#1]\vspace*{\baselineskip}}
               {\end@dblfloat}
\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}

\def \@floatboxreset {%
        \reset@font
        \small
        \@setnobreak
        \@setminipage
}

\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\newcommand\leftlegendglue{}

\def\fig@type{figure}

\newdimen\figcapgap\figcapgap=3pt
\newdimen\tabcapgap\tabcapgap=5.5pt

%%%hhh
\@ifundefined{floatlegendstyle}{\def\floatlegendstyle{\bfseries}}{}

\long\def\@caption#1[#2]#3{\par\addcontentsline{\csname
  ext@#1\endcsname}{#1}{\protect\numberline{\csname
  the#1\endcsname}{\ignorespaces #2}}\begingroup
    \@parboxrestore
    \@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
  \endgroup}

\def\capstrut{\vrule\@width\z@\@height\topskip}

\@ifundefined{captionstyle}{\def\captionstyle{\normalfont\small}}{}%%hhh

\long\def\@makecaption#1#2{%
 \captionstyle
 \ifx\@captype\fig@type
   \vskip\figcapgap
 \fi
 \setbox\@tempboxa\hbox{{\floatlegendstyle #1\floatcounterend}%
 \capstrut #2}%
 \ifdim \wd\@tempboxa >\hsize
   {\floatlegendstyle #1\floatcounterend}\capstrut #2\par
 \else
   \hbox to\hsize{\leftlegendglue\unhbox\@tempboxa\hfil}%
 \fi
 \ifx\@captype\fig@type\else
   \vskip\tabcapgap
 \fi}

\newdimen\figgap\figgap=1cc
\long\def\@makesidecaption#1#2{%
   \parbox[b]{\@tempdima}{\captionstyle{\floatlegendstyle
                                         #1\floatcounterend}#2}}
\def\sidecaption#1\caption{%
\setbox\@tempboxa=\hbox{#1\unskip}%
\if@twocolumn
 \ifdim\hsize<\textwidth\else
   \ifdim\wd\@tempboxa<\columnwidth
      \typeout{Double column float fits into single column -
            ^^Jyou'd better switch the environment. }%
   \fi
 \fi
\fi
\@tempdima=\hsize
\advance\@tempdima by-\figgap
\advance\@tempdima by-\wd\@tempboxa
\ifdim\@tempdima<3cm
    \typeout{\string\sidecaption: No sufficient room for the legend;
             using normal \string\caption. }%
   \unhbox\@tempboxa
   \let\@capcommand=\@caption
\else
   \let\@capcommand=\@sidecaption
   \leavevmode
   \unhbox\@tempboxa
   \hfill
\fi
\refstepcounter\@captype
\@dblarg{\@capcommand\@captype}}

\long\def\@sidecaption#1[#2]#3{\addcontentsline{\csname
  ext@#1\endcsname}{#1}{\protect\numberline{\csname
  the#1\endcsname}{\ignorespaces #2}}\begingroup
    \@parboxrestore
    \@makesidecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
  \endgroup}

% Define `acknowledgement' environment
\def\acknowledgement{\par\addvspace{17pt}\small\rmfamily
\trivlist\if!\ackname!\item[]\else
\item[\hskip\labelsep
{\it\ackname}]\fi}
\def\endacknowledgement{\endtrivlist\addvspace{6pt}}
% Define `noteadd' environment
\def\noteadd{\par\addvspace{17pt}\small\rmfamily
\trivlist\item[\hskip\labelsep
{\itshape\noteaddname}]}
\def\endnoteadd{\endtrivlist\addvspace{6pt}}

\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{1}
\newcommand\tableofcontents{%
    \section*{\contentsname}%
    \@starttoc{toc}%
    \addtocontents{toc}{\begingroup\protect\small}%
    \AtEndDocument{\addtocontents{toc}{\endgroup}}%
    }
\newcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty\@secpenalty
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
      \fi
    \endgroup
  \fi}
\newcommand*\l@section{\@dottedtocline{1}{0pt}{1.5em}}
\newcommand*\l@subsection{\@dottedtocline{2}{1.5em}{2.3em}}
\newcommand*\l@subsubsection{\@dottedtocline{3}{3.8em}{3.2em}}
\newcommand*\l@paragraph{\@dottedtocline{4}{7.0em}{4.1em}}
\newcommand*\l@subparagraph{\@dottedtocline{5}{10em}{5em}}
\newcommand\listoffigures{%
    \section*{\listfigurename
      \@mkboth{\listfigurename}%
              {\listfigurename}}%
    \@starttoc{lof}%
    }
\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand\listoftables{%
    \section*{\listtablename
      \@mkboth{\listtablename}{\listtablename}}%
    \@starttoc{lot}%
    }
\let\l@table\l@figure
\newdimen\bibindent
\setlength\bibindent{\parindent}
\def\@biblabel#1{#1.}
\def\@lbibitem[#1]#2{\item[{[#1]}\hfill]\if@filesw
      {\let\protect\noexpand
       \immediate
       \write\@auxout{\string\bibcite{#2}{#1}}}\fi\ignorespaces}
\newenvironment{thebibliography}[1]
     {\section*{\refname
        \@mkboth{\refname}{\refname}}\small
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy\clubpenalty4000\widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
%
\newcount\@tempcntc
\def\@citex[#1]#2{\if@filesw\immediate\write\@auxout{\string\citation{#2}}\fi
  \@tempcnta\z@\@tempcntb\m@ne\def\@citea{}\@cite{\@for\@citeb:=#2\do
    {\@ifundefined
       {b@\@citeb}{\@citeo\@tempcntb\m@ne\@citea\def\@citea{,}{\bfseries
        ?}\@warning
       {Citation `\@citeb' on page \thepage \space undefined}}%
    {\setbox\z@\hbox{\global\@tempcntc0\csname b@\@citeb\endcsname\relax}%
     \ifnum\@tempcntc=\z@ \@citeo\@tempcntb\m@ne
       \@citea\def\@citea{,\hskip0.1em\ignorespaces}\hbox{\csname b@\@citeb\endcsname}%
     \else
      \advance\@tempcntb\@ne
      \ifnum\@tempcntb=\@tempcntc
      \else\advance\@tempcntb\m@ne\@citeo
      \@tempcnta\@tempcntc\@tempcntb\@tempcntc\fi\fi}}\@citeo}{#1}}
\def\@citeo{\ifnum\@tempcnta>\@tempcntb\else
            \@citea\def\@citea{,\hskip0.1em\ignorespaces}%
  \ifnum\@tempcnta=\@tempcntb\the\@tempcnta\else
   {\advance\@tempcnta\@ne\ifnum\@tempcnta=\@tempcntb \else \def\@citea{--}\fi
    \advance\@tempcnta\m@ne\the\@tempcnta\@citea\the\@tempcntb}\fi\fi}
%
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty
\newenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \columnseprule \z@
                \columnsep 35\p@
                \twocolumn[\section*{\indexname}]%
                \@mkboth{\indexname}{\indexname}%
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}
\newcommand\@idxitem{\par\hangindent 40\p@}
\newcommand\subitem{\@idxitem \hspace*{20\p@}}
\newcommand\subsubitem{\@idxitem \hspace*{30\p@}}
\newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
\newcommand\@makefntext[1]{%
    \noindent
    \hb@xt@\bibindent{\hss\@makefnmark\enspace}#1}
%
\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\refname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Fig.}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract\runinend}
\newcommand\ackname{Acknowledgements\runinend}
\newcommand\noteaddname{Note added in proof}
% French section
\def\ds@francais{%
 \typeout{On parle francais.}%
 \def\abstractname{R\'esum\'e\runinend}%
 \def\ackname{Remerciements\runinend}%
 \def\andname{et}%
 \def\lastandname{ et}%
 \def\appendixname{Appendice}
 \def\chaptername{Chapitre}%
 \def\claimname{Pr\'etention}%
 \def\conjecturename{Hypoth\`ese}%
 \def\contentsname{Table des mati\`eres}%
 \def\corollaryname{Corollaire}%
 \def\definitionname{D\'efinition}%
 \def\examplename{Exemple}%
 \def\exercisename{Exercice}%
 \def\figurename{Fig.}%
 \def\keywordname{{\bfseries Mots-cl\'e\runinend}}
 \def\indexname{Index}
 \def\lemmaname{Lemme}%
 \def\contriblistname{Liste des contributeurs}
 \def\listfigurename{Liste des figures}%
 \def\listtablename{Liste des tables}%
 \def\mailname{Correspondence to:}
 \def\noteaddname{Note ajout\'ee \`a l'\'epreuve}%
 \def\notename{Remarque}%
 \def\partname{Partie}%
 \def\problemname{Probl\`eme}%
 \def\proofname{\'Epreuve}%
 \def\propertyname{Caract\'eristique}%
%\def\propositionname{Proposition}%
 \def\questionname{Question}%
%\def\refname{References}%
 \def\remarkname{Remarque}%
 \def\seename{voyez}
 \def\solutionname{Solution}%
%\def\subclassname{{\it Subject Classifications\/}:}
 \def\tablename{Tableau}%
 \def\theoremname{Th\'eor\`eme}%
}
%
% German section
\def\ds@deutsch{\typeout{Man spricht deutsch.}%
 \def\abstractname{Zusammenfassung\runinend}%
 \def\ackname{Danksagung\runinend}%
 \def\andname{und}%
 \def\lastandname{ und}%
 \def\appendixname{Anhang}%
 \def\chaptername{Kapitel}%
 \def\claimname{Behauptung}%
 \def\conjecturename{Hypothese}%
 \def\contentsname{Inhaltsverzeichnis}%
 \def\corollaryname{Korollar}%
%\def\definitionname{Definition}%
 \def\examplename{Beispiel}%
 \def\exercisename{\"Ubung}%
 \def\figurename{Abb.}%
 \def\keywordname{{\bfseries Schl\"usselw\"orter\runinend}}
 \def\indexname{Index}
%\def\lemmaname{Lemma}%
 \def\contriblistname{Mitarbeiter}
 \def\listfigurename{Abbildungsverzeichnis}%
 \def\listtablename{Tabellenverzeichnis}%
 \def\mailname{Correspondence to:}
 \def\noteaddname{Nachtrag}%
 \def\notename{Anmerkung}%
 \def\partname{Teil}%
%\def\problemname{Problem}%
 \def\proofname{Beweis}%
 \def\propertyname{Eigenschaft}%
%\def\propositionname{Proposition}%
 \def\questionname{Frage}%
 \def\refname{Literatur}%
 \def\remarkname{Anmerkung}%
 \def\seename{siehe}
 \def\solutionname{L\"osung}%
%\def\subclassname{{\it Subject Classifications\/}:}
 \def\tablename{Tabelle}%
%\def\theoremname{Theorem}%
}
\AtBeginDocument{\switch@texts}
\newcommand\today{}
\edef\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{1.5cc}
\setlength\columnseprule{0\p@}
%
\frenchspacing
\clubpenalty=10000
\widowpenalty=10000
\def\thisbottomragged{\def\@textbottom{\vskip\z@ plus.0001fil
\global\let\@textbottom\relax}}
\pagestyle{headings}
\pagenumbering{arabic}
\if@twocolumn
   \twocolumn
\fi
\if@referee
   \makereferee
\fi
\flushbottom



\let\if@mathematic\iffalse
% No size changing allowed, hence a copy of size10.clo is included
\renewcommand\normalsize{%
   \@setfontsize\normalsize\@xpt{10.5dd}%
   \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize
\newcommand\small{%
   \@setfontsize\small\@ixpt{10dd}%
   \abovedisplayskip 8.5\p@ \@plus3\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus2\p@
   \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \parsep 0\p@ \@plus1\p@ \@minus\p@
               \topsep 8\p@ \@plus2\p@ \@minus4\p@
               \itemsep0\p@}%
   \belowdisplayskip \abovedisplayskip
}
\let\footnotesize\small
\newcommand\scriptsize{\@setfontsize\scriptsize\@viipt\@viiipt}
\newcommand\tiny{\@setfontsize\tiny\@vpt\@vipt}
\newcommand\large{\@setfontsize\large\@xiipt{13dd}}
\newcommand\Large{\@setfontsize\Large\@xivpt{15dd}}
\newcommand\LARGE{\@setfontsize\LARGE\@xviipt{17dd}}
\newcommand\huge{\@setfontsize\huge\@xxpt{25}}
\newcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
%

\setlength{\textwidth}{170mm}
\setlength{\textheight}{255mm}
%
\def\laserrunnhead{%
    \def\\{\unskip\ \ignorespaces}\def\inst##1{\unskip{}}%
    \def\thanks##1{\unskip{}}\def\fnmsep{\unskip}%
    \instindent=\textwidth
    \advance\instindent by-\headlineindent
    \if!\the\titlerunning!\else
      \edef\@title{\the\titlerunning}%
    \fi
    \global\setbox\titrun=\hbox{\small\rm\unboldmath\ignorespaces\@title}%
    \ifdim\wd\titrun>\instindent
       \typeout{^^JWarning: Title too long for running head.}%
       \typeout{Please supply a shorter form with \string\titlerunning
                \space prior to \string\maketitle}%
       \global\setbox\titrun=\hbox{\small\rm
       Title Suppressed Due to Excessive Length}%
    \fi
    \xdef\@title{\copy\titrun}%
%
    \if!\the\authorrunning!
    \else
      \setcounter{auth}{1}%
      \edef\@author{\the\authorrunning}%
    \fi
    \ifnum\value{auth}>2
       \def\stripauthor##1\and##2\endauthor{%
       \protected@xdef\@author{##1\unskip\unskip\if!##2!\else\ et al.\fi}}%
       \expandafter\stripauthor\@author\and\endauthor
    \else
       \gdef\and{\unskip, \ignorespaces}%
       {\def\and{\noexpand\protect\noexpand\and}%
       \protected@xdef\@author{\@author}}
    \fi
    \global\setbox\authrun=\hbox{\small\unboldmath\ignorespaces
                                 \@author\unskip: \unhbox\titrun}%
    \ifdim\wd\authrun>\instindent
    \typeout{^^JWarning: The running head built automatically from
             \string\author\space and \string\title
             ^^Jexceeds the pagewidth, please supply a shorter form
             ^^Jwith \string\authorrunning\space and
             \string\titlerunning\space prior to \string\maketitle}%
    \global\setbox\authrun=\hbox{\small\rm Please give a shorter version
          with: {\tt\string\authorrunning\space and
             \string\titlerunning\space prior to \string\maketitle}}%
    \fi
    \xdef\@author{\copy\authrun}%
    \markboth{\@author}{\@author}%
}
%
\def\biography#1{\par\addvspace{21dd}\small\noindent
{\bfseries#1\unskip\ }\ignorespaces}
\def\endbiography{\par\addvspace{12pt}}

\def\biographyps#1#2{%
\begingroup
\endgraf
\skip0=0pt plus2cm
\advance\skip0 by2\bigskipamount\relax
\vskip\skip0
\small
\setbox0=\vbox\bgroup\def\par{\hfil\break}%
               \sloppy
               \noindent
               \hangindent=113pt
               %\hangafter=-16\relax alt
               \hangafter=-14\relax %neu
               \smash{\raise 6.5pt
                      \llap{\vbox to0pt{\psfig{height=5truecm,%
                                               width=3.6truecm,#1}%
                                        \vss}\kern11pt}}%
               %\vrule height\topskip width0pt
               \if!#2!\else{\sc\ignorespaces#2\/} \fi
               \ignorespaces}
%
\def\endbiographyps{\egroup
\dimen0=\ht0\advance\dimen0 by\dp0
\ifdim\dimen0<5cm
   \vtop to5cm{\box0\vss}
\else
   {\splittopskip=0pt
   \splitmaxdepth=\maxdepth
   \vbadness=10000
   \setbox1=\vsplit0 to 139.153dd
   \vtop{\box1}%
   \vskip-\prevdepth
   \unvbox0
   \endgraf}
\fi
\endgroup}


\def\theyear{}
\urlstyle{same}
\def\wwwmark{~/~\url{}}
%
%\AtEndOfClass{%
\let\if@runhead\iftrue
\let\ProcessRunnHead=\relax%\lplrunnhead%%%%hhh
%\def\@evenhead{\small\rlap{\thepage}\hfil\leftmark\unskip}%
%\def\@oddhead{\small\ignorespaces\rightmark\hfil\llap{\thepage}}%
\def\ps@default{%
  \def\@oddhead{%
%    \hbox to 0pt{%
      \vbox to \headheight{\vss\baselineskip=3pt
        \hbox to\textwidth{%
          \small  JJMS {\bf \thevol}, No.~\thenumber,
          \firstpage\--\pageref*{LastPage}
          (\theyear)%
          \wwwmark\hfill
          \smash{\lower2pt\hbox{}}%hhh
          \quad\hbox to 2em{\hfill\thepage}}%
        \leavevmode\lower2pt\rlap{\hbox to\textwidth{\hrulefill}}%
%      }%
    }%
  }%
  \def\@evenhead{\small%
    \hbox to\textwidth{%
      \vbox to \headheight{\vss\baselineskip=3pt
        \hbox to\textwidth{%
          \hbox to 2em{\thepage\hfill}\quad
          \smash{\lower2pt\hbox{}}%hhh
          \hfill\the\authorrunning:~\the\titlerunning
        }%
        \leavevmode\lower2pt\hbox to\textwidth{\hrulefill}%
      }%
    }%
  }%
  \def\@oddfoot{%
    \vbox to 0pt{%
      \vskip-\baselineskip\footfontsize\baselineskip=0pt\relax
      \vskip\normalbaselineskip
      \hbox to\textwidth{\hrulefill}\vskip\dp\strutbox
      \hbox to 0pt{%
        \rlap{\hbox to \textwidth{\strut\leftfootmark\hss}}%
        \rlap{\hbox to \textwidth{\hss\strut\midfootmark\hss}}%
        \rlap{\hbox to \textwidth{\hss\strut\rightfootmark}}%hhh
      }\vss%
    }%
  }%
  \def\@evenfoot{%
    \vbox to 0pt{%
      \vskip-\baselineskip\footfontsize\baselineskip=0pt\relax
      \vskip\normalbaselineskip
      \hbox to\textwidth{\hrulefill}\vskip\dp\strutbox
      \hbox to 0pt{%
        \rlap{\hbox to \textwidth{\strut\rightfootmark\hss}}%
        \rlap{\hbox to \textwidth{\hss\strut\midfootmark\hss}}%
        \rlap{\hbox to \textwidth{\hss\strut\leftfootmark}}%hhh
      }\vss%
    }%
  }%
}
\def\corresponding#1{\g@addto@macro\@maketitle{\thispagestyle{titlepage}}%
  \def\ps@titlepage{%
    \def\leftfootmark{#1}%
    \def\wwwmark{~~{\bf } }%hhh
    \def\@evenhead{\small%
      \hbox to\textwidth{%
        \vbox to \headheight{\vss\baselineskip=3pt
          \hbox to\textwidth{%
            \hbox to 2em{\thepage\hfill}\quad
            \smash{\lower2pt\hbox{}}%hhh
            \hfill\small  JJMS  {\bf \thevol}, No.~\thenumber,
            \firstpage\--\pageref*{LastPage}
            (\theyear)%
            \wwwmark
          }%
          \leavevmode\lower2pt\hbox to\textwidth{\hrulefill}%
        }%
      }%
    }%
  }%
}
\def\rightfootmark{\smash{\lower5mm\hbox{%%%%hhh
      \copyrightmark}}}
\def\leftfootmark{}%
\def\midfootmark{}%
\def\footfontsize{\small}
\corresponding{$^\ast$\,\mailname\ \ignorespaces \textcolor{blue}{\@mail}}
\ps@default
\setlength{\topmargin}{-1in}%
\addtolength{\topmargin}{1cm}%
\setlength{\textwidth}{17cm}%%%hhh
%\setlength{\textheight}{257.23mm}% 57cc = 257.23mm
\setlength{\textheight}{244.23mm}% 57cc = 257.23mm
\addtolength{\textheight}{-2\baselineskip}% - foot (without copyright)
% typearea correction: n * \baselineskip + \topsep (to avoid underfull \vbox)
\setlength{\@tempdima}{\textheight}
\divide\@tempdima by\baselineskip
\multiply\@tempdima by\baselineskip
\setlength{\topskip}{\textheight}
\addtolength{\topskip}{-\@tempdima}
\addtolength{\topskip}{\baselineskip}% min. \topskip
\addtolength{\textheight}{-\baselineskip}
% odd and even margin (1:2)
\setlength{\oddsidemargin}{210mm}
\addtolength{\oddsidemargin}{-\textwidth}
\divide\oddsidemargin by 3
\setlength{\evensidemargin}{2\oddsidemargin}
\addtolength{\oddsidemargin}{-1in}
\addtolength{\evensidemargin}{-1in}
%
\def\section{\@startsection{section}{1}{\z@}%
    {-21dd plus-4pt minus-4pt}{10.5dd plus 4pt
     minus4pt}{\large\bfseries}}
\def\subsection{\@startsection{subsection}{2}{\z@}%
    {-21dd plus-4pt minus-4pt}{10.5dd plus 4pt
     minus4pt}{\large\itshape}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}%
    {-21dd plus-4pt minus-4pt}{10.5dd plus 4pt
     minus4pt}{\normalsize\normalfont}}
\def\paragraph{\@startsection{subsubsection}{4}{\z@}%
    {-21dd plus-4pt minus-4pt}{-1pt}{\normalsize}}
\def\sectcounterend{}
\def\@thmcounterend{.}
\let\remark\relax
\let\proof\relax
\spnewtheorem*{remark}{Remark}{\itshape}{\rm}
\spnewtheorem*{proof}{Proof\runinend}{\itshape}{\rm}
\def\claimname{Claim}{\itshape}{\rm}
\def\proofname{Proof}{\itshape}{\rm}
\journalname{Applied Mathematics \& Information Sciences }
%}

\def\titlefont{\fontsize{18}{23pt}\sffamily} %Helvetica (Test3)
\renewcommand\@biblabel[1]{[#1]\ }
%%
%% End of copy of file `lpl.clo'.
\endinput
%%
%% End of file `JJMS.cls'.
